  ; Convert text (or attdef) to right justified text (etc.).
  ; Copyright 1993  Rocket Software
  ; Rocket Software: the ketchup of CAD.
 (DEFUN C:RIGHT (/ aa aname ten eleven newins new10 dist angl new11 nu11)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq aa (entget (setq aname (car (entsel "Text to right justify:\n")))))
  (if (or (= (cdr (assoc 0 aa)) "TEXT") (= (cdr (assoc 0 aa)) "ATTDEF"))
      (progn
          (setq ten (cdr (assoc 10 aa)))
          (setq eleven (cdr (assoc 11 aa)))
          (if (/= (cdr (assoc 72 aa)) 0)
 ; If it was not right justified text.
              (progn
                   (setq newins (getpoint eleven
                             "New insertion point (<Return> for current): "))
                   (if newins       ; new registration point picked
                      (progn
                          (setq aa (subst (cons 11 newins) (assoc 11 aa) aa))
                          (entmod (subst (cons 72 2) (assoc 72 aa) aa)))))
 ; It was right justified.
              (progn
                   (setq newins (getpoint ten
                             "New insertion point (<Return> for current): "))
                   (if newins       ; new registration point picked
                      (progn
                          (setq aa (subst (cons 11 newins) (assoc 11 aa) aa))
                          (entmod (subst (cons 72 2) (assoc 72 aa) aa))))))
 ; No new insertion picked, reregister but don't move.
          (if (null newins)
              (progn
                  (setq ten (cdr (assoc 10 aa)))       ; starting 10 pos
                  (entmod (subst (cons 72 2) (assoc 72 aa) aa))    ; change
                  (setq aa (entget aname))             ; get the changed edata
                  (setq new10 (cdr (assoc 10 aa)))     ; new 10 point
                  (setq dist (distance ten new10))     ; distance moved
                  (setq angl (angle new10 ten))        ; and angle
                  (setq new11 (cdr (assoc 11 aa)))     ; new centre point
                  (setq nu11 (polar new11 angl dist))  ; move centre as 10 was
                  (entmod (subst (cons 11 nu11) (assoc 11 aa) aa))))))
 (PRINC))